#include "main.h"
#include "title.h"
#include "input.h"

#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>

bool title_screen(void) {
	ALLEGRO_FONT *font, *font2;
	ALLEGRO_BITMAP *bitmap;
	ALLEGRO_EVENT event;
	ALLEGRO_TRANSFORM t;
	ALLEGRO_COLOR black = al_map_rgb(0, 0, 0), red = al_map_rgb(255, 0, 0), white = al_map_rgb(255, 255, 255), offWhite = al_map_rgba(255, 255, 255, 128);
	Input input;
	bool ret = false, running = true, redraw = true;
	int selection = 0, x, y, w, h;
	float cx, cy, scale, ar, tx, ty, px, py, spx, spy, qx, qy, sqx, sqy;

	al_identity_transform(&t);
	bitmap = al_get_target_bitmap();
	cx = al_get_bitmap_width(bitmap);
	cy = al_get_bitmap_height(bitmap);
	ar = cx/cy;
	scale = cy/480.0;
	al_scale_transform(&t, scale, scale);

	font = al_load_ttf_font("VeraMoBd.ttf", -80, 0);
	if (!font) return false;
	font2 = al_load_ttf_font("VeraMoBd.ttf", -30, ALLEGRO_TTF_MONOCHROME);
	if (!font2) {
		al_destroy_font(font);
		return false;
	}

	al_get_text_dimensions(font, "Lovely <3 Red", &x, &y, &w, &h);
	tx = ((480 * ar) - w) / 2.0;
	ty = 80;

	al_get_text_dimensions(font2, "Play", &x, &y, &w, &h);
	px = ((480 * ar) - w) / 2.0;
	al_get_text_dimensions(font2, "> Play <", &x, &y, &w, &h);
	spx = ((480 * ar) - w) / 2.0;

	spy = py = 300;
	sqy = qy = py + h + 5;

	al_get_text_dimensions(font2, "Quit", &x, &y, &w, &h);
	qx = ((480 * ar) - (w - x)) / 2.0;
	al_get_text_dimensions(font2, "> Quit <", &x, &y, &w, &h);
	sqx = ((480 * ar) - (w - x)) / 2.0;

	al_start_timer(timer);
	while (running) {
		while (!al_is_event_queue_empty(queue)) {
			al_get_next_event(queue, &event);

			switch (event.type) {
			case ALLEGRO_EVENT_KEY_DOWN:
				input.keyDown(&event);
				break;
			case ALLEGRO_EVENT_KEY_UP:
				input.keyUp(&event);
				break;
			case ALLEGRO_EVENT_TIMER:
				// Do Stuff!
				if (input.pausePressed()) {
					// Need a pause menu before this is done the right way
					running = false;
				}
				if (input.upPressed() || input.downPressed()) {
					selection ^= 1;
				}
				if (input.firePressed()) {
					running = false;
					if (!selection) ret = true;
				}

				input.resetChanged();
			case ALLEGRO_EVENT_DISPLAY_EXPOSE:
				redraw = true;
				break;
			case ALLEGRO_EVENT_DISPLAY_CLOSE:
				running = false;
				break;
			}
		}

		if (redraw) {
			al_use_transform(&t);
			al_clear_to_color(black);

			al_draw_text(font, red, tx, ty, 0, "Lovely <3 Red");

			if (selection) {
				al_draw_text(font2, offWhite, px, py, 0, "Play");
				al_draw_text(font2, white, sqx, sqy, 0, "> Quit <");
			} else {
				al_draw_text(font2, white, spx, spy, 0, "> Play <");
				al_draw_text(font2, offWhite, qx, qy, 0, "Quit");
			}

			al_flip_display();
			redraw = false;
		}
	}
	al_stop_timer(timer);

	al_destroy_font(font);
	al_destroy_font(font2);
	return ret;
}
