#include <allegro5/allegro.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_audio.h>
#include <math.h>

#include "main.h"
#include "game.h"
#include "input.h"
#include "player.h"
#include "entity.h"

static ALLEGRO_BITMAP *tiles[64], *mapTiles[6];

const float DELTA = 0.75;

void draw_map(Map *map, float ar) {
	int mapX, mapY;
	float x, y, x1, x2, y1, y2;

	mapX = map->startX / 32.0;
	x1 = ((int)(map->startX) % 32) * -1;
	x2 = x1 + (480 * ar) + ((int)x1 == 0 ? 0.0 : 32.0);

	mapY = map->startY / 32.0;
	y1 = ((int)(map->startY) % 32) * -1;
	y2 = y1 + 480 + ((int)y1 == 0 ? 0.0 : 32.0);

	for (y = y1; y < y2; y += 32) {
		mapX = map->startX / 32.0;

		for (x = x1; x < x2; x += 32) {
			al_draw_bitmap(mapTiles[map->tile[mapY][mapX][0]], x, y, 0);
			if (map->tile[mapY][mapX][2]) {
				al_draw_tinted_bitmap(mapTiles[map->tile[mapY][mapX][0] + 2], al_map_rgba_f(1.0, 1.0, 1.0, map->tile[mapY][mapX][2]/65536.0), x, y, 0);
			}
			if (map->tile[mapY][mapX][1]) {
				al_draw_bitmap(mapTiles[map->tile[mapY][mapX][1]], x, y, 0);
			}
			mapX++;
		}
		mapY++;
	}
}

void play_game(void) {
	std::vector<Entity *>::iterator it;
	ALLEGRO_EVENT event;
	ALLEGRO_BITMAP *tile_bitmap = NULL;
	ALLEGRO_FONT *font = NULL, *font2 = NULL;
	ALLEGRO_TRANSFORM t;
	ALLEGRO_SAMPLE *player_hit, *spray, *slime_appear, *slime_hit, *paint_pickup;
	Player player(ROOMX/2.0 - 0.5, 0.0);
	Input input;
	bool running = true, pause = false, redraw = false;
	int i, j, x, y, help_count = 2400, slime_count, win_state = 0;
	Map map;
	float scale, cx, cy, ar, target_dist;
	Entity *entity, *target;

	tile_bitmap = al_get_target_bitmap();
	cx = al_get_bitmap_width(tile_bitmap);
	cy = al_get_bitmap_height(tile_bitmap);
	ar = cx/cy;
	scale = cy/480.0;
	al_identity_transform(&t);
	al_scale_transform(&t, scale, scale);

	// Load the stuff
	for (i = 0; i < 64; ++i) {
		tiles[i] = NULL;
	}
	tile_bitmap = al_load_bitmap("tiles.png");
	if (!tile_bitmap) {
		return;
	}
	for (i = 0; i < 64; ++i) {
		x = (i % 8) * 32;
		y = (i / 8) * 32;
		tiles[i] = al_create_sub_bitmap(tile_bitmap, x, y, 32, 32);
		if (!tiles[i]) {
			running = false;
			break;
		}
	}
	mapTiles[0] = tiles[ 0]; // Red floor
	mapTiles[1] = tiles[ 1]; // Red brick wall
	mapTiles[2] = tiles[ 8]; // Green floor
	mapTiles[3] = tiles[ 9]; // Green brick wall
	mapTiles[4] = tiles[ 2]; // Door glow
	mapTiles[5] = tiles[10]; // Gun on the ground
	player.setBitmaps(tiles[16], tiles[17], tiles[11]);

	font = al_load_ttf_font("VeraMoBd.ttf", -14, ALLEGRO_TTF_MONOCHROME);
	font2 = al_load_ttf_font("VeraMoBd.ttf", -36, 0);
	if (!font) {
		running = false;
	}
	if (!font2) {
		running = false;
	}

	player_hit = al_load_sample("player_hit.ogg");
	spray = al_load_sample("spray.ogg");
	paint_pickup = al_load_sample("paint_pickup.ogg");
	slime_appear = al_load_sample("slime_appear.ogg");
	slime_hit = al_load_sample("slime_hit.ogg");
	player.setSounds(player_hit, spray);

	for (i = 0; i < ROOMY; ++i) {
		for (j = 0; j < ROOMX; ++j) {
			if (i == 0) {
				map.tile[i][j][0] = 1;
			} else if (i == ROOMY - 1) {
				map.tile[i][j][0] = 1;
			} else if (j == 0) {
				map.tile[i][j][0] = 1;
			} else if (j == ROOMX - 1) {
				map.tile[i][j][0] = 1;
			} else {
				map.tile[i][j][0] = 0;
			}
			map.tile[i][j][1] = 0; // Nothing in the object layer by default.
			map.tile[i][j][2] = 0; // Tiles are not faded green yet.
		}
		// Fill that last column
		map.tile[i][j][0] = 0;
		map.tile[i][j][1] = 0;
		map.tile[i][j][2] = 0;
	}
	map.maxX = ROOMX * 32;
	map.maxY = ROOMY * 32;
	map.startX = (ROOMX * 32.0 - 480 * ar) / 2.0;
	map.startY = 0.0;	
	if (map.startX + (480 * ar) >= map.maxX) {
		map.startX = map.maxX - (480 *ar);
	}

	// TODO Place random objects here

	map.tile[1][ROOMX/2][1] = 4;
	gunX = rand() % (ROOMX * 2) + 1; // If it's outside the range, then you will have your gun.
	gunY = rand() % (ROOMY - 2) + 1;
	if (gunX > ROOMX -2) gunX = 0;
	if (gunX) map.tile[gunY][gunX][1] = 5;

	j = rand() % 10 + 15; // 5 to 25
	for (i = 0; i < j; ++i) {
		entity = new Entity(rand() % (ROOMX - 2) + 1, rand() % ((ROOMY - 2) / 2) + ((ROOMY - 2) / 2), Entity::TYPE_SLIME);
		slimes.push_back(entity);
	}
	slime_count = (int)slimes.size();

	al_start_timer(timer);
	while(running) {
		while(!al_is_event_queue_empty(queue)) {
			al_get_next_event(queue, &event);

			switch(event.type) {
			case ALLEGRO_EVENT_KEY_DOWN:
				input.keyDown(&event);
				break;
			case ALLEGRO_EVENT_KEY_UP:
				input.keyUp(&event);
				break;
			case ALLEGRO_EVENT_TIMER:
				// Logic stuff

				if (input.pausePressed()) {
					// Need a pause menu before this is done the right way
					running = false;
				}

				player.logic(&map, &input, ar);

				it = slimes.begin();
				target_dist = 0.0;
				target = NULL;
				while (it != slimes.end()) {
					entity = *it;
					if (entity->needSound()) {
						entity->setSound(slime_hit);
					}
					if (!entity->logic(&map, &player)) {
						delete entity;
						it = slimes.erase(it);
					} else {
						cx = player.getX() - entity->getX();
						cy = player.getY() - entity->getY();
						scale = sqrt(cx * cx + cy * cy);
						if (scale > target_dist) {
							target = entity;
							target_dist = scale;
						}
						it++;
					}
				}
				it = pickups.begin();
				while (it != pickups.end()) {
					entity = *it;
					if (!entity->logic(&map, &player)) {
						delete entity;
						it = pickups.erase(it);
					} else {
						it++;
					}
				}

				/** Begin Lazyines coding **/
				// If there's slimes, but you're out of ammo, drop an ammo pickup
				if (player.getAmmo() < 1.0 && (int)slimes.size() > 0 && (int)pickups.size() == 0) {
					entity = new Entity((rand() % (ROOMX - 2)) + 1, (rand() % (ROOMY -2)) + 1, Entity::TYPE_PAINT);
					pickups.push_back(entity);
					if (paint_pickup) al_play_sample(paint_pickup, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);
				}
				help_count--;
				if (!help_count) {
					help_count = 2400;
					slime_count = slime_count - (int)slimes.size();
					if (slime_count > 5) {
						for(slime_count = slime_count / 2 ; slime_count > 0; --slime_count) {
							entity = new Entity((rand() % (ROOMX - 2)) + 1, (rand() % (ROOMY -2)) + 1, Entity::TYPE_SLIME);
							slimes.push_back(entity);
						}
						if (slime_appear) al_play_sample(slime_appear, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);
					} else if (slime_count < 2) {
						if (target) target->kill();
					}
					slime_count = (int)slimes.size();
				}
				if ((int)slimes.size() == 0) {
					win_state = 1;
					slime_count = 0;
				}
				if (player.getHealth() < 1) {
					win_state = -1;
				}
				/** End Lazyiness coding **/

				if (map.startY + 480 >= map.maxY) {
					map.startY = map.maxY - 480;
				}
				if (map.startY < 0.0) {
					map.startY = 0.0;
				}
				if (map.startX + (480 * ar) >= map.maxX) {
					map.startX = map.maxX - (480 * ar);
				}
				if (map.startX < 0.0) {
					map.startX = 0.0;
				}
				input.resetChanged();
				
			case ALLEGRO_EVENT_DISPLAY_EXPOSE:
				redraw = true;
				break;
			case ALLEGRO_EVENT_DISPLAY_CLOSE:
				running = false;
				break;
			case ALLEGRO_EVENT_DISPLAY_SWITCH_OUT:
				pause = true;
				break;
			default:
				break;
			}

		}
		if (redraw) {
			// Draw the screen!
			al_clear_to_color(al_map_rgb(0, 0, 0));
			al_use_transform(&t);

			draw_map(&map, ar);

			it = pickups.begin();
			while (it != pickups.end()) {
				entity = *it;
				if (entity->needBitmaps()) {
					entity->setBitmaps(tiles[3], NULL);
				}
				entity->render(&map);
				it++;
			}

			it = slimes.begin();
			while (it != slimes.end()) {
				entity = *it;
				if (entity->needBitmaps()) {
					entity->setBitmaps(tiles[25], tiles[24]);
				}
				entity->render(&map);
				it++;
			}
			player.render(&map);

			al_draw_textf(font, al_map_rgb(255, 255, 255), 1.0,  1.0, 0, "Health: %d", player.getHealth());
			al_draw_textf(font, al_map_rgb(255, 255, 255), 1.0, 15.0, 0, "Ammo: %d", (int)player.getAmmo());

			if (win_state >= 1) {
				al_get_text_dimensions(font2, "YOU WIN!", &x, &y, &i, &j);
				cy = (480 - j) / 2.0;
				cx = ((480 * ar) - i) / 2.0;
				al_draw_text(font2, al_map_rgb(255, 255, 255), cx, cy, 0, "YOU WIN!");
			}
			if (win_state <= -1) {
				al_get_text_dimensions(font2, "YOU LOST!", &x, &y, &i, &j);
				cy = (480 - j) / 2.0;
				cx = ((480 * ar) - i) / 2.0;
				al_draw_text(font2, al_map_rgb(255, 255, 255), cx, cy, 0, "YOU LOST!");
			}

			al_flip_display();
			redraw = false;
		}
	}
	al_stop_timer(timer);

	// Cleanup
	for (it = slimes.begin(); it != slimes.end(); it++) {
		entity = *it;
		delete entity;
	}
	slimes.clear();
	
	for (it = pickups.begin(); it != pickups.end(); it++) {
		entity = *it;
		delete entity;
	}
	pickups.clear();

	for (i = 0; i < 64; ++i) {
		al_destroy_bitmap(tiles[i]);
	}
	al_destroy_bitmap(tile_bitmap);
	al_destroy_font(font);
	al_destroy_font(font2);
	al_flush_event_queue(queue);
}
