#include "entity.h"
#include "player.h"

#include <math.h>

Entity::Entity(float x, float y, int type) :
x(x), y(y), type(type), dir(0.0), isHurt(false), dx(0), dy(0), time(0), normal(NULL), hurt(NULL), slime_hit(NULL), ani(0.0) {
	switch (type) {
	case TYPE_SLIME:
		health = 120;
		break;
	default:
		health = 1200;
	}
}

void Entity::setBitmaps(ALLEGRO_BITMAP *normal, ALLEGRO_BITMAP *hurt) {
	this->normal = normal;
	this->hurt = hurt;
}

bool Entity::needBitmaps() {
	return !(bool)normal;
}

void Entity::setSound(ALLEGRO_SAMPLE *slime_hit) {
	this->slime_hit = slime_hit;
}

bool Entity::needSound() {
	return !(bool)slime_hit;
}

int Entity::getType() {
	return type;
}

float Entity::getX() {
	return x;
}

float Entity::getY() {
	return y;
}

void Entity::kill() {
	Entity *entity = new Entity(x, y, TYPE_PAINT);
	pickups.push_back(entity);
	isHurt = true;
}

bool Entity::logic(Map *map, Player *player) {
	float px, py, dist;
	int i, j;
	if (isHurt) {
		health--;
	}
	if (health < 0) {
		return false;
	}
	ani += 1.5;
	if (ani >= 360) ani = 0.0;

	switch (type) {
	case TYPE_SLIME:
		// Move randomly
		if (!isHurt) {
			if (!time) {
				time = rand() % 360 + 120;
				dx = rand() % 3 - 1;
				dy = rand() % 3 - 1;
			}
			time--;

			switch (dy) {
			case 1:
				y += 0.0125;
				switch (dx) {
				case 1:
					dir = ALLEGRO_PI / 4 * 7;
					x += 0.0125;
					break;
				case -1:
					dir = ALLEGRO_PI / 4;
					x -= 0.0125;
					break;
				case 0:
					dir = 0;
					break;
				}
				break;
			case -1:
				y -= 0.0125;
				switch (dx) {
				case 1:
					dir = ALLEGRO_PI / 4 * 5;
					x += 0.0125;
					break;
				case -1:
					dir = ALLEGRO_PI / 4 * 3;
					x -= 0.0125;
					break;
				case 0:
					dir = ALLEGRO_PI;
					break;
				}
				break;
			case 0:
				switch (dx) {
				case 1:
					dir = ALLEGRO_PI / 2 * 3;
					x += 0.0125;
					break;
				case -1:
					dir = ALLEGRO_PI / 2;
					x -= 0.0125;
					break;
				}
			}

			// Check to make sure the slime is in the room
			if (y < 1.0) {
				y = 1.0;
				dy = 0;
			}
			if (x < 1.0) {
				x = 1.0;
				dx = 0;
			}
			if (y > ROOMY - 2) {
				y = ROOMY - 2;
				dy = 0;
			}
			if (x > ROOMX - 2) {
				x = ROOMX - 2;
				dx = 0;
			}

			// Check to see if the slime is hurting the player, or the player is hurting the slime.
			if (player->isFire()) {
				px = player->getX() + sin(player->getDir()) * -1;
				py = player->getY() + cos(player->getDir());
				px = x - px;
				py = y - py;
				dist = sqrt(px * px + py * py);
				if (dist < 1.0) {
					isHurt = true;
					if (slime_hit) al_play_sample(slime_hit, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);
					if (rand() % 2 == 0) {
						Entity *entity = new Entity(x, y, TYPE_PAINT);
						pickups.push_back(entity);
					}
				}
			}
			if (!isHurt) {
				px = x - player->getX();
				py = y - player->getY();
				dist = sqrt(px * px + py * py);
				if (dist < 0.9) {
					player->hit();
				}
			}
		}

		// Color the main square the slime is on.
		px = ((x - (int)x) > 0.5) ? x + 1.0 : x;
		py = ((y - (int)y) > 0.5) ? y + 1.0 : y;
		for (i = -1; i < 2; ++i) {
			for (j = -1; j < 2; ++j) {
				if (isHurt) {
					map->tile[(int)py + j][(int)px + i][2] -= (i == 0 && j == 0) ? 1000 : 500;
					if (map->tile[(int)py + j][(int)px + i][2] < 0)
						map->tile[(int)py + j][(int)px + i][2] = 0;

				} else {
					map->tile[(int)py + j][(int)px + i][2] += (i == 0 && j == 0) ? 50 : 25;
					if (map->tile[(int)py + j][(int)px + i][2] > 65536)
						map->tile[(int)py + j][(int)px + i][2] = 65536;
				}

			}
		}

		break;
	case TYPE_PAINT:
		health--;
		if (!health) {
			return false;
		}
		px = x - player->getX();
		py = y - player->getY();
		dist = sqrt(px * px + py * py);
		if (dist < 0.7) {
			dist = 5.0 - 0.5;
			player->giveAmmo(dist * (rand() % 10000) / 10000.0);
			return false;
		}

	default:
		break;
	}
	return true;
}

void Entity::render(Map *map) {
	float rx = x * 32 - map->startX + 16, ry = y * 32 - map->startY + 16;
	if (isHurt) {
		al_draw_scaled_rotated_bitmap(hurt, 16, 16, rx, ry, health/120.0, health/120.0, dir, 0);
	} else {
		al_draw_scaled_rotated_bitmap(normal, 16, 16, rx, ry, abs(sin(ALLEGRO_PI / 180.0 * ani)) / 4.0 + 0.75, abs(cos(ALLEGRO_PI / 180.0 * ani)) / 4.0 + 0.75, dir, 0);
	}
}
