#include <math.h>

#include "player.h"

Player::Player(float x, float y) : x(x), y(y), health(10), dir(0.0), ammo(10.0), fire(0), hurt(0) {
}

void Player::setBitmaps(ALLEGRO_BITMAP *noGun, ALLEGRO_BITMAP *gun, ALLEGRO_BITMAP *spray) {
	this->noGun = noGun;
	this->gun = gun;
	this->spray = spray;
}

void Player::setSounds(ALLEGRO_SAMPLE *player_hit, ALLEGRO_SAMPLE *spray_sound) {
	this->player_hit = player_hit;
	this->spray_sound = spray_sound;
}

void Player::logic(Map *map, Input *input, float ar) {
	int dx = 0, dy = 0;
	float cx, cy;

	if (health < 1) {
		fire = false;
		return;
	}
	if (y < 1.0) {
		y += 0.025;
		return;
	}
	map->tile[1][ROOMX/2][1] = 0; // Clear the glow
	if (input->upDown()) {
		dy--;
	}
	if (input->downDown()) {
		dy++;
	}
	if (input->leftDown()) {
		dx--;
	}
	if (input->rightDown()) {
		dx++;
	}

	switch (dy) {
	case 1:
		y += 0.025;
		switch (dx) {
		case 1:
			dir = ALLEGRO_PI / 4 * 7;
			x += 0.025;
			break;
		case -1:
			dir = ALLEGRO_PI / 4;
			x -= 0.025;
			break;
		case 0:
			dir = 0;
			break;
		}
		break;
	case -1:
		y -= 0.025;
		switch (dx) {
		case 1:
			dir = ALLEGRO_PI / 4 * 5;
			x += 0.025;
			break;
		case -1:
			dir = ALLEGRO_PI / 4 * 3;
			x -= 0.025;
			break;
		case 0:
			dir = ALLEGRO_PI;
			break;
		}
		break;
	case 0:
		switch (dx) {
		case 1:
			dir = ALLEGRO_PI / 2 * 3;
			x += 0.025;
			break;
		case -1:
			dir = ALLEGRO_PI / 2;
			x -= 0.025;
			break;
		}
	}

	if (y < 1.0) y = 1.0;
	if (x < 1.0) x = 1.0;
	if (y > ROOMY - 2) y = ROOMY - 2;
	if (x > ROOMX - 2) x = ROOMX - 2;

	// Check gun
	if (gunX) {
		cx = x - gunX;
		cy = y - gunY;
		cx = sqrt(cx * cx + cy * cy);
		if (cx < 0.9) {
			map->tile[gunY][gunX][1] = 0;
			gunX = 0;
		}
	} else {
		if (input->firePressed() && ammo > 0.9 && !fire) {
			fire = 30;
			ammo -= 1.0;
			if (spray_sound) al_play_sample(spray_sound, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);
		}
	}
	if (fire) fire--;

	// Move map
	map->startX = (x + 0.5) * 32 - (240 * ar);
	map->startY = (y + 0.5) * 32 - 240;
	if (hurt) {
		hurt--;
	}
}

void Player::render(Map *map){
	ALLEGRO_COLOR tint = al_map_rgba(255, 255, 255, (hurt) ? 128 : 255);
	float rx = x * 32 - map->startX + 16, ry = y * 32 - map->startY + 16;
	al_draw_tinted_rotated_bitmap((gunX ? noGun : gun), tint, 16, 16, rx, ry, dir, 0);

	if (fire) {
		rx = (x + sin(dir) * -1) * 32 - map->startX + 16;
		ry = (y + cos(dir)) * 32 - map->startY + 16;
		al_draw_rotated_bitmap(spray, 16, 16, rx, ry, dir, 0);
	}
}

void Player::hit() {
	if (!hurt) {
		hurt = 240;
		health--;
		if (player_hit) al_play_sample(player_hit, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);
	}
}

bool Player::isFire() {
	return (bool)fire;
}

float Player::getX() {
	return x;
}

float Player::getY() {
	return y;
}

float Player::getDir() {
	return dir;
}

float Player::getAmmo() {
	return ammo;
}

void Player::giveAmmo(float amount) {
	ammo += amount;
}

int Player::getHealth() {
	return health;
}
