#ifndef PLAYER_H
#define PLAYER_H

#include "main.h"
#include "input.h"
#include <allegro5/allegro_audio.h>

class Player {
public:
	Player(float x, float y);

	void setBitmaps(ALLEGRO_BITMAP *noGun, ALLEGRO_BITMAP *gun, ALLEGRO_BITMAP *spray);
	void setSounds(ALLEGRO_SAMPLE *player_hit, ALLEGRO_SAMPLE *spray_sound);
	void logic(Map *map, Input *input, float ar);
	void render(Map *map);
	void hit();
	bool isAlive();
	bool isFire();
	float getX();
	float getY();
	float getDir();
	float getAmmo();
	void giveAmmo(float amount);
	int getHealth();

private:
	float x;
	float y;
	int health;
	float dir; // down is 0, right is 3pi/2, up is pi, and left is pi/2, I think
	float ammo;
	int fire;
	int hurt;
	ALLEGRO_BITMAP *noGun, *gun, *spray;
	ALLEGRO_SAMPLE *player_hit, *spray_sound;
	
};

#endif // PLAYER_H