#ifndef ENTITY_H
#define ENTITY_H

#include "main.h"
#include <allegro5/allegro_audio.h>

class Player;

class Entity {
public:
	static const int TYPE_SLIME = 0;
	static const int TYPE_PAINT = 1;
	Entity(float x, float y, int type = TYPE_SLIME);

	// As these are created during gameplay, a function is needed to check to see if the bitmaps need to be added
	// Hurt only needed for slimes
	void setBitmaps(ALLEGRO_BITMAP *normal, ALLEGRO_BITMAP *hurt);
	bool needBitmaps();
	void setSound(ALLEGRO_SAMPLE *slime_hit);
	bool needSound();
	int getType();
	float getX();
	float getY();
	void kill();

	bool logic(Map *map, Player *player);
	void render(Map *map);

private:
	float x;
	float y;
	int type;
	float dir;
	bool isHurt;
	int dx;
	int dy;
	int time;
	int health;
	ALLEGRO_BITMAP *normal, *hurt;
	ALLEGRO_SAMPLE *slime_hit;
	float ani;

};

#endif // ENTITY_H